/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerNameResolver;
import net.minecraft.util.HttpUtil;

public class DualStackUtils {
    public static boolean checkIPv6(String hostAddress) {
        Optional<InetSocketAddress> hostAddr = ServerNameResolver.f_171881_.m_171890_(ServerAddress.m_171864_((String)hostAddress)).map(ResolvedServerAddress::m_142641_);
        if (hostAddr.isPresent()) {
            return DualStackUtils.checkIPv6(hostAddr.get().getAddress());
        }
        return false;
    }

    public static boolean checkIPv6(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            System.setProperty("java.net.preferIPv4Stack", "false");
            System.setProperty("java.net.preferIPv6Addresses", "true");
            return true;
        }
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("java.net.preferIPv6Addresses", "false");
        return false;
    }

    @Nullable
    public static InetAddress getLocalAddress() {
        InetAddress localAddr = new InetSocketAddress(HttpUtil.m_13939_()).getAddress();
        if (localAddr.isAnyLocalAddress()) {
            return localAddr;
        }
        try {
            return InetAddress.getByName("localhost");
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String getMulticastGroup() {
        if (DualStackUtils.checkIPv6(DualStackUtils.getLocalAddress())) {
            return "FF75:230::60";
        }
        return "224.0.2.60";
    }
}

